/*
 * Decompiled with CFR 0.152.
 */
package sedona.platform;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sedona.Env;
import sedona.Facets;
import sedona.platform.ParFile;
import sedona.platform.PlatformDbException;
import sedona.platform.PlatformManifest;
import sedona.util.FileUtil;
import sedona.util.TextUtil;
import sedona.util.sedonadev.Download;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XLocation;
import sedona.xml.XParser;
import sedona.xml.XWriter;

public final class PlatformDb {
    public static final File dbDir = new File(new File(Env.home, "platforms"), "db");
    private static final String manifestName = "platformManifest.xml";
    private static final String parDirName = ".par";

    public static final PlatformDb db() {
        return SingletonHolder.INSTANCE;
    }

    public final void install(PlatformManifest platformManifest) {
        try {
            PlatformManifest.validate(platformManifest);
            File file = this.initInstall(platformManifest);
            File file2 = new File(file, manifestName);
            XWriter xWriter = new XWriter(file2);
            platformManifest.encodeXml(xWriter);
            xWriter.flush();
            xWriter.close();
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    public final void install(ParFile parFile) {
        PlatformManifest platformManifest = parFile.getPlatformManifest();
        try {
            PlatformManifest.validate(platformManifest);
            File file = this.initInstall(platformManifest);
            Enumeration<? extends ZipEntry> enumeration = parFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.pipe(parFile.getInputStream(zipEntry), byteArrayOutputStream);
                this.writeEntry(file, zipEntry, byteArrayOutputStream);
            }
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    /*
     * Exception decompiling
     */
    public final void install(ZipInputStream var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 119->122)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final File initInstall(PlatformManifest platformManifest) throws IOException {
        File file = this.toParLocation(platformManifest.id);
        FileUtil.delete(file, null);
        FileUtil.mkdir(file, null);
        return file;
    }

    private final void writeEntry(File file, ZipEntry zipEntry, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Object object;
        String string = zipEntry.getName();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/") || zipEntry.isDirectory()) {
            FileUtil.mkdir(new File(file, string), null);
            return;
        }
        int n = string.lastIndexOf(47);
        if (n > 0) {
            object = string.substring(0, n);
            FileUtil.mkdir(new File(file, (String)object), null);
        }
        object = new FileOutputStream(new File(file, string));
        byteArrayOutputStream.writeTo((OutputStream)object);
        ((FileOutputStream)object).close();
    }

    public final void extract(String string, File file) {
        File file2 = this.toParLocation(string);
        if (!file2.exists()) {
            throw new PlatformDbException("'" + string + "' is not in the database");
        }
        try {
            FileUtil.copyDir(file2, file, null);
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void extractPar(String string, File file) {
        File file2 = this.toParLocation(string);
        if (!file2.exists()) {
            throw new PlatformDbException("'" + string + "' is not in the database");
        }
        try {
            FileUtil.mkdir(file.getParentFile(), null);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            try {
                this.zip(zipOutputStream, file2, "");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                zipOutputStream.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                zipOutputStream.close();
                return;
            }
        }
        catch (Exception exception) {
            throw new PlatformDbException(exception);
        }
    }

    private final void zip(ZipOutputStream zipOutputStream, File file, String string) throws Exception {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                this.zip(zipOutputStream, file2, string.length() == 0 ? file2.getName() + '/' : string + file2.getName() + '/');
            } else {
                ZipEntry zipEntry = new ZipEntry(string + file2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(file2);
                FileUtil.pipe(fileInputStream, zipOutputStream);
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            ++n;
        }
    }

    public final String[] list() {
        ArrayList arrayList = new ArrayList();
        this.list(arrayList, dbDir, new ArrayList());
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private final void list(ArrayList arrayList, File file, ArrayList arrayList2) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string = file2.getName();
            if (file2.isDirectory()) {
                if (string.equals(parDirName)) {
                    arrayList.add(TextUtil.join(arrayList2.toArray(), "-"));
                } else {
                    arrayList2.add(string);
                    this.list(arrayList, file2, arrayList2);
                    arrayList2.remove(arrayList2.size() - 1);
                }
            }
            ++n;
        }
    }

    public final PlatformManifest load(String string) throws XException {
        PlatformMatch platformMatch = this.matchBest(string);
        if (platformMatch == null) {
            return null;
        }
        XElem xElem = this.parseManifest(platformMatch.manifest);
        if (!xElem.get("platformId").startsWith(platformMatch.matchId)) {
            throw new XException(string + " does not start with matched platform manifest id " + platformMatch.matchId, xElem);
        }
        return PlatformManifest.decodeXml(xElem);
    }

    public final PlatformManifest loadExact(String string) throws XException {
        PlatformManifest platformManifest = this.load(string);
        return platformManifest != null && string.equals(platformManifest.id) ? platformManifest : null;
    }

    public final DbVm getVm(PlatformManifest platformManifest) {
        return this.getVm(platformManifest.id);
    }

    public final DbVm getVm(String string) {
        PlatformMatch platformMatch = this.matchBest(string);
        if (platformMatch == null) {
            return null;
        }
        File file = new File(platformMatch.manifest.getParentFile(), "svm");
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        File file2 = null;
        int n = 0;
        while (n < fileArray.length) {
            String string2 = fileArray[n].getName();
            if (!(string2.endsWith(".xml") || string2.endsWith(".scode") || string2.endsWith(".sax") || string2.endsWith(".sab"))) {
                file2 = fileArray[n];
                break;
            }
            ++n;
        }
        return file2 == null ? null : new DbVm(platformMatch.matchId, file2);
    }

    private final File toParLocation(String string) {
        String[] stringArray = TextUtil.split(string, '-');
        File file = dbDir;
        int n = 0;
        while (n < stringArray.length) {
            file = new File(file, stringArray[n]);
            ++n;
        }
        return new File(file, parDirName);
    }

    private final PlatformMatch matchBest(String string) {
        Object[] objectArray = TextUtil.split(string, '-');
        File file = null;
        String string2 = null;
        int n = objectArray.length;
        while (n > 0) {
            string2 = TextUtil.join(objectArray, 0, n, "-");
            file = new File(this.toParLocation(string2), manifestName);
            if (file.exists()) break;
            --n;
        }
        if (!string.equals(string2)) {
            try {
                this.install(Download.fetchPar(string));
                file = new File(this.toParLocation(string), manifestName);
                string2 = string;
            }
            catch (Exception exception) {}
        }
        return file.exists() ? new PlatformMatch(file, string2) : null;
    }

    private final XElem parseManifest(File file) {
        try {
            return XParser.make(file).parse();
        }
        catch (Exception exception) {
            throw new XException("Cannot parse XML file", new XLocation(file.toString()));
        }
    }

    public static final void main(String[] stringArray) {
        Facets facets = PlatformDb.parseOpts(stringArray);
        try {
            if (facets.getb("list")) {
                PlatformDb.showList(facets);
            } else if (facets.getb("install")) {
                PlatformDb.db().install(new ParFile(facets.gets("par")));
            } else if (facets.getb("extract")) {
                PlatformDb.db().extract(facets.gets("id"), new File(facets.gets("out", facets.gets("id"))));
            } else {
                PlatformDb.err("No actions to take");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PlatformDb.err(exception.getMessage());
        }
    }

    private static final void showList(Facets facets) {
        String[] stringArray = PlatformDb.db().list();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    private static final Facets parseOpts(String[] stringArray) {
        Facets facets = new Facets();
        if (stringArray.length == 0) {
            PlatformDb.err("No options");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-h") || string.equals("--help")) {
                PlatformDb.showHelp(0);
            } else if (string.equals("-l") || string.equals("--list")) {
                facets.setb("list", true);
            } else if (string.equals("-i")) {
                if (n + 1 >= stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -i option");
                }
                facets.setb("install", true);
                facets.sets("par", stringArray[++n]);
            } else if (string.equals("-x") || string.equals("--extract")) {
                if (n + 1 >= stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -x option");
                }
                facets.setb("extract", true);
                facets.sets("id", stringArray[++n]);
            } else if (string.equals("-o") || string.equals("--out")) {
                if (n + 1 >= stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    PlatformDb.err("Missing argument for -o option");
                }
                facets.sets("out", stringArray[++n]);
            } else {
                PlatformDb.err("Unrecognized option '" + string + '\'');
            }
            ++n;
        }
        return facets;
    }

    private static final void err(String string) {
        System.err.println("\nError: " + string);
        PlatformDb.showHelp(1);
    }

    private static final void showHelp(int n) {
        System.out.println();
        System.out.println("usage:");
        System.out.println("  PlatformDb [OPTIONS]");
        System.out.println("options:");
        System.out.println("  -l, --list          List all platforms in the database");
        System.out.println("  -i platform.par     Install the given PAR file into the platform database");
        System.out.println("  -x, --extract <ID>  Extract all files for the platform with the given ID");
        System.out.println("                      to ./<ID>/. Use -o to change the output location.");
        System.out.println("  -o, --out LOC       Change the default output location to LOC");
        System.out.println("  -h, --help          Print this usage");
        System.out.println();
        System.exit(n);
    }

    private PlatformDb() {
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
    }

    private static class SingletonHolder {
        private static final PlatformDb INSTANCE = new PlatformDb();

        private SingletonHolder() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PlatformMatch {
        public final File manifest;
        public final String matchId;

        public PlatformMatch(File file, String string) {
            this.manifest = file;
            this.matchId = string;
        }
    }

    public static final class DbVm {
        private final String platformId;
        private final File svm;

        public final String id() {
            return this.platformId;
        }

        public final String name() {
            return this.svm.getName();
        }

        public final File copyTo(File file) throws IOException {
            File file2 = new File(file, this.name());
            FileUtil.copyFile(this.svm, file2);
            return file2;
        }

        DbVm(String string, File file) {
            this.platformId = string;
            this.svm = file;
        }
    }
}

